/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.config;

import com.simibubi.create.content.kinetics.BlockStressValues;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import uwu.lopyluna.create_dd.config.CreateDDConfigBase;
import uwu.lopyluna.create_dd.config.client.CreateDDClientConfig;
import uwu.lopyluna.create_dd.config.common.CreateDDCommonConfig;
import uwu.lopyluna.create_dd.config.server.CreateDDServerConfig;

public class DDConfigs {
    private static final Map<ModConfig.Type, CreateDDConfigBase> CONFIGS = new EnumMap<ModConfig.Type, CreateDDConfigBase>(ModConfig.Type.class);
    private static CreateDDClientConfig client;
    private static CreateDDCommonConfig common;
    private static CreateDDServerConfig server;

    public static CreateDDClientConfig client() {
        return client;
    }

    public static CreateDDCommonConfig common() {
        return common;
    }

    public static CreateDDServerConfig server() {
        return server;
    }

    public static CreateDDConfigBase byType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends CreateDDConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            CreateDDConfigBase config = (CreateDDConfigBase)factory.get();
            config.registerAll((ForgeConfigSpec.Builder)builder);
            return config;
        });
        CreateDDConfigBase config = (CreateDDConfigBase)specPair.getLeft();
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)config;
    }

    public static void register() {
        client = DDConfigs.register(CreateDDClientConfig::new, ModConfig.Type.CLIENT);
        common = DDConfigs.register(CreateDDCommonConfig::new, ModConfig.Type.COMMON);
        server = DDConfigs.register(CreateDDServerConfig::new, ModConfig.Type.SERVER);
        for (Map.Entry<ModConfig.Type, CreateDDConfigBase> pair : CONFIGS.entrySet()) {
            ForgeConfigRegistry.INSTANCE.register("create_dd", pair.getKey(), (IConfigSpec)pair.getValue().specification);
        }
        BlockStressValues.registerProvider((String)"create_dd", (BlockStressValues.IStressValueProvider)DDConfigs.server().kinetics.stressValues);
    }
}

